varying vec2 f_texcoord;
varying float f_alpha;
varying vec4 f_colorLight;

uniform sampler2D tex;
uniform vec3 water_color;

#ifdef WAVE
varying float f_posZ;
#endif

#if defined(FOG)
varying float f_fogFactor;
#endif

#if defined(SEA)
varying float f_seaBorder;
#endif


void main(void)
{
	float alpha = f_alpha;

#ifdef WAVE
	if(f_posZ < SHORE_Z)
	{
		alpha = 0.0;
		discard;
	}
#endif

	if(alpha == 0.0)
		discard;

	vec4 colorResult = texture2D(tex, f_texcoord);
	colorResult *= vec4(2.0*water_color, 1.0);

	//Result
	colorResult = f_colorLight * colorResult;
	colorResult.w *= alpha;

#if defined(SHORE)
	const float alphaAdd = 0.1;
	const float foamPow = 8.0;
	const float foamMult = 1.5;
	float foamFactor = pow(min(1.0, 1.0-alpha+alphaAdd), foamPow);
	colorResult.rgb *= 1.0+foamMult*foamFactor;
#endif

#if defined(FOG)
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR*FOG_COLOR_ADAPT, f_fogFactor);
#endif

#if defined(SEA)
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR, f_seaBorder);
#endif

	gl_FragColor = colorResult;
}
